<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormColumnValue extends Eloquent {

	protected $table = 'form_column_values';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('form_column_id', 'multiple_per_row');

	public function formColumn()
	{
		return $this->belongsTo('FormColumn');
	}

	public function formDataType()
	{
		return $this->belongsTo('FormDataType');
	}

}