<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TicketCategory extends Model 
{

    protected $table = 'ticket_categories';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function events()
    {
        return $this->belongsToMany('Event')->withPivot('ammount','comment_de','quantity_sold');
    }

}