<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('type_id')->unsigned()->index();
			$table->string('membership_type', 50);
			$table->integer('payment_type_id')->unsigned()->index();
			$table->string('name', 150);
			$table->string('code', 20);
			$table->integer('status')->default('1');
			$table->boolean('is_bank')->default(true);
			$table->integer('channel_id')->unsigned()->nullable()->index();
			$table->boolean('is_whitelist')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}