<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('insurances', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('name', 255);
			$table->string('code', 15);
			$table->string('slug', 20);
			$table->string('logo', 255);
			$table->integer('city_id')->unsigned()->index();
			$table->integer('status')->default('1');
			$table->string('npwp', 30)->nullable();
			$table->enum('jv_type', array('jv', 'local'));
			$table->integer('type_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('insurances');
	}
}