<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyDetailsTable extends Migration {

	public function up()
	{
		Schema::create('company_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('company_id')->unsigned()->index();
			$table->text('address')->nullable();
			$table->integer('city_id')->unsigned()->nullable()->index();
			$table->string('phone', 30);
			$table->string('fax', 30)->nullable();
			$table->string('email', 50)->nullable();
			$table->integer('status')->default('1');
			$table->string('npwp', 30);
		});
	}

	public function down()
	{
		Schema::drop('company_details');
	}
}