<?php

namespace App\Models;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('course_id', 'student_id', 'price', 'order_id');

	public function student()
	{
		return $this->belongsTo('App\Models\Student', 'student_id');
	}

	public function course()
	{
		return $this->belongsTo('App\Models\Course', 'course_id');
	}

}