<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name');
			$table->text('description')->nullable();
			$table->text('requirements')->nullable();
			$table->integer('owner_id')->unsigned();
			$table->integer('rate')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}