<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->longText('description')->nullable();
			$table->double('price')->nullable();
			$table->double('offer')->nullable();
			$table->string('image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}