<?php

namespace Models/Representative;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Representative extends Model 
{

    protected $table = 'representatives';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function representative_country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function representative_city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}