<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->longText('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->string('video', 255)->nullable();
			$table->date('date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}