<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->longText('body')->nullable();
			$table->string('file', 255)->nullable();
			$table->integer('topic_detail_id')->unsigned()->nullable();
			$table->integer('client_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}