<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketRepliesTable extends Migration {

	public function up()
	{
		Schema::create('ticket_replies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('ticket_id')->unsigned()->nullable();
			$table->longText('description')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('type', 255)->nullable();
			$table->string('file')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ticket_replies');
	}
}