<?php

namespace Models/Client;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function client_country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function client_city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}