<?php

namespace Models/Operator;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Operator extends Eloquent {

	protected $table = 'operators';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function operator_country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function operator_city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}