<?php

namespace Models/Representative;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Representative extends Eloquent {

	protected $table = 'representatives';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function representative_country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function representative_city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}