<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255)->nullable();
			$table->longText('body');
			$table->integer('client_id')->nullable();
			$table->integer('company_id')->nullable();
			$table->integer('representative_id')->nullable();
			$table->integer('operator_id')->nullable();
			$table->string('read_at', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}