<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRepresentativesTable extends Migration {

	public function up()
	{
		Schema::create('representatives', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name', 255);
			$table->integer('age')->nullable();
			$table->string('email', 255)->nullable();
			$table->string('phone', 40)->nullable();
			$table->string('gender', 255)->nullable();
			$table->text('address')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('image', 255)->nullable();
			$table->longText('about')->nullable();
			$table->json('services');
			$table->boolean('verified_mail')->default(0);
			$table->integer('otp')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('representatives');
	}
}