<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone', 40)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('whatsapp', 40)->nullable();
			$table->text('facebook')->nullable();
			$table->text('twitter')->nullable();
			$table->text('linkedin')->nullable();
			$table->text('address')->nullable();
			$table->text('location')->nullable();
			$table->string('vedio', 255)->nullable();
			$table->boolean('allow_captcha')->default(1);
			$table->boolean('allow_phone_auth')->default(1);
			$table->boolean('allow_mail_auth')->default(1);
			$table->boolean('allow_recovery_password')->default(1);
			$table->boolean('allow_live_chat')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}