<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTopicDetailsTable extends Migration {

	public function up()
	{
		Schema::create('topic_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255)->nullable();
			$table->longText('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->string('video', 255)->nullable();
			$table->integer('topic_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('topic_details');
	}
}