<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatricesTable extends Migration {

	public function up()
	{
		Schema::create('matrices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('office_id')->unsigned();
			$table->enum('type', array('domestic', 'import', 'export', 'external'));
			$table->json('settings');
			$table->json('zone_schema');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('matrices');
	}
}