<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountGridTable extends Migration {

	public function up()
	{
		Schema::create('account_grid', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('domestic', 'import', 'export', 'external'));
			$table->date('start_date');
			$table->date('end_date');
			$table->timestamps();
			$table->bigInteger('account_id')->unsigned();
			$table->bigInteger('grid_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('account_grid');
	}
}