<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('offices', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matrices', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('offices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('offices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('account_service', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('account_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matrix_service', function(Blueprint $table) {
			$table->foreign('matrix_id')->references('id')->on('matrices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matrix_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tariffs', function(Blueprint $table) {
			$table->foreign('grid_id')->references('id')->on('grids')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matrix_grid', function(Blueprint $table) {
			$table->foreign('matrix_id')->references('id')->on('matrices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matrix_grid', function(Blueprint $table) {
			$table->foreign('grid_id')->references('id')->on('grids')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('account_grid', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('account_grid', function(Blueprint $table) {
			$table->foreign('grid_id')->references('id')->on('grids')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('offices', function(Blueprint $table) {
			$table->dropForeign('offices_country_id_foreign');
		});
		Schema::table('matrices', function(Blueprint $table) {
			$table->dropForeign('matrices_office_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_office_id_foreign');
		});
		Schema::table('account_service', function(Blueprint $table) {
			$table->dropForeign('account_service_account_id_foreign');
		});
		Schema::table('account_service', function(Blueprint $table) {
			$table->dropForeign('account_service_service_id_foreign');
		});
		Schema::table('matrix_service', function(Blueprint $table) {
			$table->dropForeign('matrix_service_matrix_id_foreign');
		});
		Schema::table('matrix_service', function(Blueprint $table) {
			$table->dropForeign('matrix_service_service_id_foreign');
		});
		Schema::table('tariffs', function(Blueprint $table) {
			$table->dropForeign('tariffs_grid_id_foreign');
		});
		Schema::table('matrix_grid', function(Blueprint $table) {
			$table->dropForeign('matrix_grid_matrix_id_foreign');
		});
		Schema::table('matrix_grid', function(Blueprint $table) {
			$table->dropForeign('matrix_grid_grid_id_foreign');
		});
		Schema::table('account_grid', function(Blueprint $table) {
			$table->dropForeign('account_grid_account_id_foreign');
		});
		Schema::table('account_grid', function(Blueprint $table) {
			$table->dropForeign('account_grid_grid_id_foreign');
		});
	}
}