<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountServiceTable extends Migration {

	public function up()
	{
		Schema::create('account_service', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->enum('type', array('domestic', 'import', 'export', 'external'));
			$table->json('prices');
			$table->date('start_date');
			$table->date('end_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('account_service');
	}
}