<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('account_number');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('first_name', 64)->index();
			$table->string('middle_name', 64)->nullable();
			$table->string('last_name', 64);
			$table->string('occupation');
			$table->string('mother_name', 128)->nullable();
			$table->string('father_name', 128)->nullable();
			$table->string('spouse_name', 128)->nullable();
			$table->enum('sex', array('MALE', 'FEMALE'))->index();
			$table->string('zipcode', 10)->index();
			$table->enum('status', array('ACTIVE', 'DEACTIVATED'))->index();
			$table->boolean('is_primary');
			$table->integer('parent_account')->unsigned()->nullable()->index();
			$table->integer('branch_id')->unsigned();
			$table->double('balance', 12,2)->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}