<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTellersTable extends Migration {

	public function up()
	{
		Schema::create('tellers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->string('first_name', 64)->index();
			$table->string('middle_name')->nullable()->index();
			$table->string('last_name', 64)->index();
			$table->integer('branch_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tellers');
	}
}