<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('amount', 8,2);
			$table->enum('status', array('PENDING', 'APPROVED', 'CANCELLED'))->index();
			$table->text('remarks')->nullable();
			$table->integer('account_number')->unsigned();
			$table->enum('type', array('DEPOSIT', 'WITHDRAWAL'))->index();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}