<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentAddressesTable extends Migration {

	public function up()
	{
		Schema::create('payment_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('contact_name')->nullable();
			$table->string('contact_email')->nullable();
			$table->string('contact_phone')->nullable();
			$table->string('id_number')->nullable();
			$table->string('address_title')->nullable();
			$table->text('address');
			$table->string('country')->nullable();
			$table->string('state')->nullable();
			$table->string('city')->nullable();
			$table->string('posta_code')->nullable();
			$table->enum('type', array('individual', 'corporate'));
			$table->string('company_name')->nullable();
			$table->string('tax_number')->nullable();
			$table->string('tax_office')->nullable();
			$table->string('c_var')->nullable();
			$table->integer('c_int')->nullable();
			$table->text('c_txt')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payment_addresses');
	}
}