<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartItemsTable extends Migration {

	public function up()
	{
		Schema::create('cart_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('cart_id')->unsigned();
			$table->string('model_type')->nullable();
			$table->bigInteger('model_id')->unsigned()->nullable();
			$table->string('model_price_key')->nullable();
			$table->integer('currency_id')->unsigned();
			$table->integer('quantity')->unsigned()->nullable();
			$table->double('unit_price', 12,4)->default('0.0');
			$table->double('unit_tax', 12,4)->default('0.0');
			$table->double('sub_total', 12,4)->default('0.0');
			$table->double('tax', 12,4)->default('0.0');
			$table->double('tax_rate', 6,3)->default('0.0');
			$table->double('total', 12,4)->default('0.0');
			$table->double('discount', 12,4)->default('0.0');
			$table->double('grand_total', 12,4)->default('0.0');
			$table->string('c_var')->nullable();
			$table->integer('c_int');
			$table->text('c_txt')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cart_items');
	}
}