<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->string('uid')->nullable();
			$table->integer('currency_id')->unsigned();
			$table->integer('quantity')->unsigned()->nullable();
			$table->double('sub_total', 12,4)->default('0.0');
			$table->double('tax', 12,4)->default('0.0');
			$table->double('tax_rate', 6,3)->default('0.0');
			$table->double('total', 12,4)->default('0.0');
			$table->double('discount', 12,4)->nullable()->default('0.0');
			$table->double('grand_total', 12,4)->default('0.0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}