<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('uid', 'status', 'user_id', 'billing_address_id', 'shipping_address_id', 'currency_id', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total', 'installment', 'response');
	protected $visible = array('uid', 'status', 'user_id', 'billing_address_id', 'shipping_address_id', 'currency_id', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total', 'installment', 'response');

	public function billingAddress()
	{
		return $this->belongsTo('PaymentAddress', 'billing_address_id');
	}

	public function shipping_address()
	{
		return $this->belongsTo('PaymentAddress', 'shipping_address_id');
	}

	public function items()
	{
		return $this->hasMany('OrderItem');
	}

	public function cart()
	{
		return $this->hasOne('Cart');
	}

	public function currency()
	{
		return $this->belongsTo('Currency');
	}

}