<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'user_id', 'uid', 'currency_id', 'quantity', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total');
	protected $visible = array('order_id', 'user_id', 'uid', 'currency_id', 'quantity', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total');

	public function items()
	{
		return $this->hasMany('CartItem');
	}

	public function currency()
	{
		return $this->belongsTo('Currency');
	}

}