<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItem extends Eloquent {

	protected $table = 'order_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'status');
	protected $visible = array('order_id', 'status');

	public function order()
	{
		return $this->belongsTo('Order');
	}

	public function currency()
	{
		return $this->belongsTo('Currency');
	}

}