<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HandOver extends Model 
{

    protected $table = 'hand_over';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('employee_id', 'supervisor_id', 'amount', 'status', 'mall_id', 'country_id', 'confirmed_at');

    public function employee()
    {
        return $this->belongsTo('User', 'employee_id');
    }

    public function supervisor()
    {
        return $this->belongsTo('User', 'supervisor_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}