<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Warehouse extends Model 
{

    protected $table = 'warehouse';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'supply_id', 'total_quantity', 'out_quantity', 'damaged_quantity');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

}