<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplyInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('supply_invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('supply_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('price')->nullable();
			$table->double('total')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('bill_no')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('supply_invoice');
	}
}