<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('invitations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('object', 100);
			$table->integer('object_id')->nullable();
			$table->string('email', 100);
			$table->string('token', 16)->unique();
			$table->boolean('accepted')->default(0);
			$table->timestamp('accepted_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invitations');
	}
}