<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order')->default('1');
			$table->string('name', 255)->unique()->default('slug');
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}