<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('author_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->text('excerpt')->nullable();
			$table->text('body')->nullable();
			$table->string('image', 255)->nullable();
			$table->string('slug', 255)->unique();
			$table->text('meta_description');
			$table->text('meta_keywords')->nullable();
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}