<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'display_name');
	protected $visible = array('name', 'display_name');

	public function permissions()
	{
		return $this->hasMany('Permission');
	}

}