<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('role_id', 'name', 'email', 'avatar', 'password', 'remember_token');
	protected $visible = array('role_id', 'name', 'email', 'avatar');

	public function role()
	{
		return $this->hasOne('Role');
	}

}