<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKidsTable extends Migration {

	public function up()
	{
		Schema::create('kids', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned();
			$table->string('kid_name', 255);
			$table->string('nick_name', 255);
			$table->integer('age');
			$table->enum('status_flag', array('1', '0'));
		});
	}

	public function down()
	{
		Schema::drop('kids');
	}
}