<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoriesTable extends Migration {

	public function up()
	{
		Schema::create('stories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->enum('status_flag', array('1', '0'));
			$table->string('title', 255);
			$table->string('image', 255);
			$table->string('video', 255);
			$table->string('category_json');
			$table->string('language_json', 255);
		});
	}

	public function down()
	{
		Schema::drop('stories');
	}
}