<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('kids', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('notification', function(Blueprint $table) {
			$table->foreign('origin_user')->references('id')->on('admin')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notification', function(Blueprint $table) {
			$table->foreign('notifier')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('banner', function(Blueprint $table) {
			$table->foreign('story_id')->references('id')->on('stories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_user_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_role_id_foreign');
		});
		Schema::table('kids', function(Blueprint $table) {
			$table->dropForeign('kids_parent_id_foreign');
		});
		Schema::table('notification', function(Blueprint $table) {
			$table->dropForeign('notification_origin_user_foreign');
		});
		Schema::table('notification', function(Blueprint $table) {
			$table->dropForeign('notification_notifier_foreign');
		});
		Schema::table('banner', function(Blueprint $table) {
			$table->dropForeign('banner_story_id_foreign');
		});
	}
}