<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationTable extends Migration {

	public function up()
	{
		Schema::create('notification', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->integer('origin_user')->unsigned();
			$table->integer('notifier')->unsigned();
			$table->enum('notifier_status', array('1', '0'));
			$table->string('content', 255);
			$table->string('title', 255);
		});
	}

	public function down()
	{
		Schema::drop('notification');
	}
}