<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupPlanObjectItem extends Model 
{

    protected $table = 'group_plan_object_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group_plan_object()
    {
        return $this->belongsTo('GroupPlanObject');
    }

    public function group_plan_objects_items_todos()
    {
        return $this->hasMany('GroupPlanObjectItemsTodo');
    }

}