<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubtypeServicesTable extends Migration {

	public function up()
	{
		Schema::create('subtype_services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->bigInteger('service_id');
			$table->string('feature', 250);
			$table->string('variations', 250);
			$table->date('start_date');
			$table->date('end_date');
			$table->decimal('price', 10,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subtype_services');
	}
}