<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function bookings()
	{
		return $this->hasMany('Booking', 'booking_id');
	}

	public function subscrptions()
	{
		return $this->hasMany('Subscription', 'user_id');
	}

	public function pets()
	{
		return $this->hasMany('Pet', 'user_id');
	}

	public function payments()
	{
		return $this->hasMany('Payment', 'user_id');
	}

	public function phones()
	{
		return $this->morphMany('Phone', 'phoneable');
	}

	public function addresses()
	{
		return $this->morphMany('Address', 'addressable');
	}

}