<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->bigInteger('pet_id');
			$table->bigInteger('service_id');
			$table->date('date');
			$table->time('time');
			$table->time('pickup_time');
			$table->time('dropoff_time');
			$table->decimal('price', 10,2);
			$table->bigInteger('subtype_id');
			$table->enum('status', array('schudle', 'cancel', 'completed'));
			$table->bigInteger('branch_id');
			$table->bigInteger('booking_id');
			$table->timestamps();
			$table->boolean('has_transportation')->default(false);
			$table->bigInteger('employee_id');
			$table->string('dropoff_location');
			$table->string('pickup_location');
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}