<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBreedsTable extends Migration {

	public function up()
	{
		Schema::create('breeds', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->bigInteger('pettype_id');
			$table->text('description');
			$table->enum('status', array('1', '0'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('breeds');
	}
}