<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('service_discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('service_id');
			$table->enum('discount_type', array('days', 'pets'));
			$table->decimal('discount_percentage', 5,2);
			$table->decimal('total_discount', 10,2);
			$table->integer('number_of');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_discounts');
	}
}